FILESEXTRAPATHS_append := ":${THISDIR}/${PN}"

SRC_URI_append = " \
                   file://syslogctl \
                   file://mdlogctl \
                   file://syslog-start \
                   file://klogd-start \
                   file://busybox-syslog.default \
                   file://add-syslog.cfg \
                   file://busybox-syslog.service.in \
                   file://busybox-klogd.service.in \
                   file://tcpdump-start \
                   file://tcpdump.service.in \
                   file://ring_buf.patch \
                   file://busybox_syslog_high_precision_timestamp.patch \
                   file://coredump.service.in \
                   file://coredump-start \
                   file://coredump-handler.sh \
                   file://0001-Revert-remove-systemd-support.patch \
                   file://busyboxmakefile.patch \                   
                 "
inherit systemd

SYSTEMD_SERVICE_${PN}-syslog_append = "${@bb.utils.contains('BUILD_LOAD_TYPE', 'user', ' coredump.service', ' tcpdump.service coredump.service', d)}"

FILES_${PN}-syslog_append = " ${systemd_unitdir}/system/tcpdump.service \
                              ${systemd_unitdir}/system/coredump.service \
                            "

do_install_append() {
    install -m 0755 ${WORKDIR}/syslogctl ${D}/bin/
    install -m 0755 ${WORKDIR}/mdlogctl ${D}/bin/
    install -m 0755 ${WORKDIR}/syslog-start ${D}/bin/
    install -m 0755 ${WORKDIR}/klogd-start ${D}/bin/
    install -m 0755 ${WORKDIR}/coredump-start ${D}/bin/
    install -m 0755 ${WORKDIR}/coredump-handler.sh ${D}/bin/
    install -m 0644 ${WORKDIR}/coredump.service.in ${D}${systemd_unitdir}/system/coredump.service
    if [ "${BUILD_LOAD_TYPE}" = "user" ]; then
        echo "*.err         /var/log/syslog.log"> ${D}/etc/syslog.conf
    else
        install -m 0755 ${WORKDIR}/tcpdump-start ${D}/bin/
        install -m 0644 ${WORKDIR}/tcpdump.service.in ${D}${systemd_unitdir}/system/tcpdump.service
    fi
}

